/* -LICENSE-START-
** Copyright (c) 2009 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
// SignalGeneratorDlg.h : header file
//

#pragma once

#include "Resource.h"
#include "DeckLinkAPI_h.h"
#include "SignalGenerator3DVideoFrame.h"

// Custom Messages
#define WM_ADD_DEVICE_MESSAGE					(WM_APP + 1)
#define WM_REMOVE_DEVICE_MESSAGE				(WM_APP + 2)


enum OutputSignal
{
	kOutputSignalPip		= 0,
	kOutputSignalDrop		= 1
};

// Forward declarations
class DeckLinkDeviceDiscovery;
class DeckLinkOutputDevice;
class PreviewWindow;

// CSignalGeneratorDlg dialog
class CSignalGeneratorDlg : public CDialog
{
// Construction
public:
	explicit CSignalGeneratorDlg(CWnd* pParent = NULL);	// standard constructor
	virtual ~CSignalGeneratorDlg() {};

	// Dialog Data
	enum { IDD = IDD_SIGNALGENERATOR_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
private:
	HICON						m_hIcon;
	//
	CButton						m_startButton;
	CComboBox					m_deviceListCombo;
	CComboBox					m_outputSignalCombo;
	CComboBox					m_audioChannelCombo;
	CComboBox					m_audioSampleDepthCombo;
	CComboBox					m_videoFormatCombo;
	CComboBox					m_pixelFormatCombo;
	
	CStatic						m_previewBox;
	PreviewWindow*				m_previewWindow;

	bool						m_running;
	
	unsigned long				m_frameWidth;
	unsigned long				m_frameHeight;
	BMDTimeValue				m_frameDuration;
	BMDTimeScale				m_frameTimescale;
	unsigned long				m_framesPerSecond;
	SignalGenerator3DVideoFrame*	m_videoFrameBlack;
	SignalGenerator3DVideoFrame*	m_videoFrameBars;
	unsigned long				m_totalFramesScheduled;
	
	OutputSignal				m_outputSignal;
	void*						m_audioBuffer;
	unsigned long				m_audioBufferSampleLength;
	unsigned long				m_audioSamplesPerFrame;
	unsigned long				m_audioChannelCount;
	BMDAudioSampleRate			m_audioSampleRate;
	BMDAudioSampleType			m_audioSampleDepth;
	unsigned long				m_totalAudioSecondsScheduled;

	DeckLinkOutputDevice* 		m_selectedDevice;
	DeckLinkDeviceDiscovery*	m_deckLinkDiscovery;

	// Generated message map functions
	virtual BOOL	OnInitDialog();
	void			EnableInterface (BOOL enable);
	afx_msg void	OnPaint();
	afx_msg void	OnClose();
	afx_msg HCURSOR	OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
	
	// Signal Generator Implementation
	void			StartRunning ();
	void			StopRunning ();

	void			RefreshDisplayModeMenu(void);
	void			RefreshAudioChannelMenu(void);
	void			AddDevice(IDeckLink* deckLink);
	void			RemoveDevice(IDeckLink* deckLink);


public:
	void			ScheduleNextFrame(bool prerolling);
	void			WriteNextAudioSamples();

	afx_msg void OnBnClickedOk();
	afx_msg void OnNewDeviceSelected();

	afx_msg LRESULT	OnAddDevice(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT	OnRemoveDevice(WPARAM wParam, LPARAM lParam);

private:
	SignalGenerator3DVideoFrame* CreateBlackFrame(void);
	SignalGenerator3DVideoFrame* CreateBarsFrame(void);
public:
	afx_msg void OnCbnSelchangeComboSignal();
	afx_msg void OnCbnSelchangeComboPixelFormat();
};


void	FillSine (void* audioBuffer, unsigned long samplesToWrite, unsigned long channels, unsigned long sampleDepth);
void	FillColourBars (IDeckLinkVideoFrame* theFrame, bool reversed);
void	FillBlack (IDeckLinkVideoFrame* theFrame);
